<?php
defined('FIR') OR exit();
/**
 * The main template file
 * This file puts together the three main section of the software, header, content and footer
 */
?>

<!DOCTYPE html>
<html>
	<head>
	    <!-- ==============================================
		Title and Meta Tags
		=============================================== -->
		<meta charset="utf-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Admin - <?=e($this->siteSettings('title'))?></title>
		<meta name="description" content="<?=e($this->siteSettings('description'))?>">
		<meta name="keywords" content="<?=e($this->siteSettings('keywords'))?>">
		
		<!-- ==============================================
		Favicons
		=============================================== --> 
        <link href="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('favicon'))?>" rel="icon">
		
		<!-- ==============================================
		Fonts
		=============================================== --> 
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Work+Sans:300,400,700&amp;display=swap">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
        
		
		<!-- ==============================================
		CSS
		=============================================== --> 
        
            <!-- fontawesome icon -->
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/fonts/fontawesome/css/fontawesome-all.min.css">
            <!-- animation css -->
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/animation/css/animate.min.css">
            <!-- vendor css -->
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/css/style.css">
            <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.css">
        
		<!-- ==============================================
		Scripts
		=============================================== --> 
        <?php if($data['url'] == 'voter_results' || $data['url'] == 'results'): ?>
          <script type="text/javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.flash.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
          <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.html5.min.js"></script>
          <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.5/js/buttons.print.min.js"></script>       
        <?php else: ?>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/js/vendor-all.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/bootstrap/js/bootstrap.min.js"></script>
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/sweetalert/sweetalert.min.js"></script> 
         <script src="https://canvasjs.com/assets/script/canvasjs.min.js"></script>   
        <?php endif; ?>
        
		
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?=e($this->siteSettings('analytics'))?>"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?=e($this->siteSettings('analytics'))?>');
		</script>	
  </head>
  
<body>
     
     <!-- ==============================================
     Wrapper Section
     =============================================== -->
	 <div class="wrapper">
			<?php if($data['url'] != 'login'): ?>
		      <?=$data['navigation_view']?>
		      <?=$data['sidenav_view']?>
			<?php endif; ?>
	 	
			<?=$data['content_view']?>
	  
			<?=$data['footer_view']?>
        
	 
		<!-- ==============================================
		Scripts
		=============================================== --> 
         <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/js/pcoded.min.js"></script>
        <?php if($data['url'] == 'voter_results' || $data['url'] == 'results'): ?>
          <script>
          $(document).ready( function () {
            $('#myLab').DataTable({
                  "ordering": false,   
                    dom: 'Bfrtip',
                    buttons: [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ] 
            });
          } );  

          </script>        
        <?php else: ?>
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/datatables/datatables.min.js"></script>
          <script>
          $(document).ready( function () {
            $('#myTable').DataTable({
                  "ordering": false,    
            });
          } );  

          </script>     
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.js"></script>
            <script>
                $(document).ready(function() {
                  $('#summernote,#summernote-1,#summernote-2,#summernote-3,#summernote-4').summernote({
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']], 
                        ['para', ['ul', 'ol', 'paragraph']],
                      ],				 
                  });
                });
            </script>          
        <?php endif; ?>      
         
         
			<?=$data['scripts_view']?>
	 	
     </div><!-- /.wrapper -->  
</body>
</html>